DocsApp.guidesTree = {
    "Guides": [
        {
            "displayNew": true,
            "name": "Getting Started",
            "slug": "getting_started",
            "children": [
                {
                    "name": "Getting Started with npm",
                    "slug": "getting_started_with_npm",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Getting Started with npm",
                    "idx": 1,
                    "id": "getting_started/getting_started_with_npm",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/getting_started/getting_started_with_npm.html"
                },
                {
                    "name": "Getting Started with zip",
                    "slug": "getting_started_with_zip",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Getting Started with zip",
                    "idx": 2,
                    "id": "getting_started/getting_started_with_zip",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/getting_started/getting_started_with_zip.html"
                },
                {
                    "name": "Add-on Components",
                    "slug": "getting_started_addons",
                    "children": [
                        {
                            "name": "Using Ext JS add-ons with npm",
                            "slug": "getting_started_with_npm",
                            "navTreeName": "Guides",
                            "text": "Using Ext JS add-ons with npm",
                            "idx": 1,
                            "id": "getting_started/getting_started_addons/getting_started_with_npm",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/getting_started/getting_started_addons/getting_started_with_npm.html"
                        },
                        {
                            "name": "Using Ext JS add-ons with Cmd",
                            "slug": "getting_started_with_cmd",
                            "navTreeName": "Guides",
                            "text": "Using Ext JS add-ons with Cmd",
                            "idx": 2,
                            "id": "getting_started/getting_started_addons/getting_started_with_cmd",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/getting_started/getting_started_addons/getting_started_with_cmd.html"
                        },
                        {
                            "name": "Using Ext JS add-ons with Zip",
                            "slug": "getting_started_with_zip",
                            "navTreeName": "Guides",
                            "text": "Using Ext JS add-ons with Zip",
                            "idx": 3,
                            "id": "getting_started/getting_started_addons/getting_started_with_zip",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/getting_started/getting_started_addons/getting_started_with_zip.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Add-on Components",
                    "idx": 3,
                    "id": "getting_started/getting_started_addons",
                    "iconCls": "fa fa-folder-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "Getting Started",
            "idx": 1,
            "id": "getting_started",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "What's New",
            "slug": "whats_new",
            "children": [
                {
                    "displayNew": true,
                    "name": "What's New",
                    "slug": "whats_new",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "What's New",
                    "idx": 1,
                    "id": "whats_new/whats_new",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/whats_new/whats_new.html"
                },
                {
                    "displayNew": true,
                    "name": "Release Notes",
                    "slug": "release_notes",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Release Notes",
                    "idx": 2,
                    "id": "whats_new/release_notes",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/whats_new/release_notes.html"
                },
                {
                    "displayNew": true,
                    "name": "Upgrade Guide",
                    "slug": "extjs_upgrade_guide",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Upgrade Guide",
                    "idx": 3,
                    "id": "whats_new/extjs_upgrade_guide",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/whats_new/extjs_upgrade_guide.html"
                },
                {
                    "name": "API Diffs",
                    "slug": "api_diffs",
                    "children": [
                        {
                            "name": "7.3",
                            "slug": "73",
                            "children": [
                                {
                                    "name": "Modern - 7.2.0 to 7.3.0",
                                    "slug": "730_modern_diff",
                                    "toolkit": "modern",
                                    "navTreeName": "Guides",
                                    "text": "Modern - 7.2.0 to 7.3.0",
                                    "idx": 1,
                                    "id": "whats_new/api_diffs/73/730_modern_diff",
                                    "leaf": true,
                                    "iconCls": "modern-guide",
                                    "href": "guides/whats_new/api_diffs/73/730_modern_diff.html"
                                },
                                {
                                    "name": "Classic - 7.2.0 to 7.3.0",
                                    "slug": "730_classic_diff",
                                    "toolkit": "classic",
                                    "navTreeName": "Guides",
                                    "text": "Classic - 7.2.0 to 7.3.0",
                                    "idx": 2,
                                    "id": "whats_new/api_diffs/73/730_classic_diff",
                                    "leaf": true,
                                    "iconCls": "classic-guide",
                                    "href": "guides/whats_new/api_diffs/73/730_classic_diff.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "7.3",
                            "idx": 1,
                            "id": "whats_new/api_diffs/73",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "7.2",
                            "slug": "72",
                            "children": [
                                {
                                    "name": "Modern - 7.1.0 to 7.2.0",
                                    "slug": "720_modern_diff",
                                    "toolkit": "modern",
                                    "navTreeName": "Guides",
                                    "text": "Modern - 7.1.0 to 7.2.0",
                                    "idx": 1,
                                    "id": "whats_new/api_diffs/72/720_modern_diff",
                                    "leaf": true,
                                    "iconCls": "modern-guide",
                                    "href": "guides/whats_new/api_diffs/72/720_modern_diff.html"
                                },
                                {
                                    "name": "Classic - 7.1.0 to 7.2.0",
                                    "slug": "720_classic_diff",
                                    "toolkit": "classic",
                                    "navTreeName": "Guides",
                                    "text": "Classic - 7.1.0 to 7.2.0",
                                    "idx": 2,
                                    "id": "whats_new/api_diffs/72/720_classic_diff",
                                    "leaf": true,
                                    "iconCls": "classic-guide",
                                    "href": "guides/whats_new/api_diffs/72/720_classic_diff.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "7.2",
                            "idx": 2,
                            "id": "whats_new/api_diffs/72",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "7.1",
                            "slug": "71",
                            "children": [
                                {
                                    "name": "Modern - 7.0.0 to 7.1.0",
                                    "slug": "710_modern_diff",
                                    "toolkit": "modern",
                                    "navTreeName": "Guides",
                                    "text": "Modern - 7.0.0 to 7.1.0",
                                    "idx": 1,
                                    "id": "whats_new/api_diffs/71/710_modern_diff",
                                    "leaf": true,
                                    "iconCls": "modern-guide",
                                    "href": "guides/whats_new/api_diffs/71/710_modern_diff.html"
                                },
                                {
                                    "name": "Classic - 7.0.0 to 7.1.0",
                                    "slug": "710_classic_diff",
                                    "toolkit": "classic",
                                    "navTreeName": "Guides",
                                    "text": "Classic - 7.0.0 to 7.1.0",
                                    "idx": 2,
                                    "id": "whats_new/api_diffs/71/710_classic_diff",
                                    "leaf": true,
                                    "iconCls": "classic-guide",
                                    "href": "guides/whats_new/api_diffs/71/710_classic_diff.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "7.1",
                            "idx": 3,
                            "id": "whats_new/api_diffs/71",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "7.0",
                            "slug": "70",
                            "children": [
                                {
                                    "name": "Modern - 6.7.0 to 7.0.0",
                                    "slug": "700_modern_diff",
                                    "toolkit": "modern",
                                    "navTreeName": "Guides",
                                    "text": "Modern - 6.7.0 to 7.0.0",
                                    "idx": 1,
                                    "id": "whats_new/api_diffs/70/700_modern_diff",
                                    "leaf": true,
                                    "iconCls": "modern-guide",
                                    "href": "guides/whats_new/api_diffs/70/700_modern_diff.html"
                                },
                                {
                                    "name": "Modern - 6.7.0 to 7.0.0",
                                    "slug": "700_classic_diff",
                                    "toolkit": "modern",
                                    "navTreeName": "Guides",
                                    "text": "Modern - 6.7.0 to 7.0.0",
                                    "idx": 2,
                                    "id": "whats_new/api_diffs/70/700_classic_diff",
                                    "leaf": true,
                                    "iconCls": "modern-guide",
                                    "href": "guides/whats_new/api_diffs/70/700_classic_diff.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "7.0",
                            "idx": 4,
                            "id": "whats_new/api_diffs/70",
                            "iconCls": "fa fa-folder-o"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "API Diffs",
                    "idx": 4,
                    "id": "whats_new/api_diffs",
                    "iconCls": "fa fa-folder-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "What's New",
            "idx": 2,
            "id": "whats_new",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Examples",
            "slug": "examples",
            "children": [
                {
                    "link": "https://examples.sencha.com/extjs/latest/",
                    "name": "7.3.0 Examples",
                    "slug": "730examples",
                    "navTreeName": "Guides",
                    "text": "7.3.0 Examples",
                    "idx": 1,
                    "id": "examples/730examples",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "Examples",
            "idx": 3,
            "id": "examples",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Choosing Components",
            "slug": "components",
            "children": [
                {
                    "name": "Calendar",
                    "slug": "calendar",
                    "toolkit": "universal",
                    "tier": "premium",
                    "navTreeName": "Guides",
                    "text": "Calendar",
                    "idx": 1,
                    "id": "components/calendar",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/components/calendar.html"
                },
                {
                    "name": "Carousel",
                    "slug": "carousel",
                    "toolkit": "modern",
                    "navTreeName": "Guides",
                    "text": "Carousel",
                    "idx": 2,
                    "id": "components/carousel",
                    "leaf": true,
                    "iconCls": "modern-guide",
                    "href": "guides/components/carousel.html"
                },
                {
                    "name": "Exporter",
                    "slug": "exporter",
                    "tier": "premium",
                    "navTreeName": "Guides",
                    "text": "Exporter",
                    "idx": 3,
                    "id": "components/exporter",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/components/exporter.html"
                },
                {
                    "name": "Forms",
                    "slug": "forms",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Forms",
                    "idx": 4,
                    "id": "components/forms",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/components/forms.html"
                },
                {
                    "name": "Froala",
                    "slug": "froala",
                    "toolkit": "universal",
                    "tier": "premium",
                    "navTreeName": "Guides",
                    "text": "Froala",
                    "idx": 5,
                    "id": "components/froala",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/components/froala.html"
                },
                {
                    "name": "Introduction to Charting",
                    "slug": "introduction_to_charting",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Introduction to Charting",
                    "idx": 6,
                    "id": "components/introduction_to_charting",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/components/introduction_to_charting.html"
                },
                {
                    "name": "Data Grids",
                    "slug": "grids",
                    "toolkit": "universal",
                    "children": [
                        {
                            "name": "Row Operations",
                            "slug": "row_operations",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Row Operations",
                            "idx": 1,
                            "id": "components/grids/row_operations",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/row_operations.html"
                        },
                        {
                            "name": "Column Operations",
                            "slug": "column_operations",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Column Operations",
                            "idx": 2,
                            "id": "components/grids/column_operations",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/column_operations.html"
                        },
                        {
                            "name": "Rendering & Scrolling",
                            "slug": "rendering_scrolling",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Rendering & Scrolling",
                            "idx": 3,
                            "id": "components/grids/rendering_scrolling",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/rendering_scrolling.html"
                        },
                        {
                            "name": "Data Import & Export",
                            "slug": "data_import_export",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Data Import & Export",
                            "idx": 4,
                            "id": "components/grids/data_import_export",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/data_import_export.html"
                        },
                        {
                            "name": "Layouts & Styling",
                            "slug": "layouts_styling",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Layouts & Styling",
                            "idx": 5,
                            "id": "components/grids/layouts_styling",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/layouts_styling.html"
                        },
                        {
                            "name": "Widget Integration",
                            "slug": "widget_integration",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Widget Integration",
                            "idx": 6,
                            "id": "components/grids/widget_integration",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/widget_integration.html"
                        },
                        {
                            "name": "Pivoting",
                            "slug": "pivoting",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Pivoting",
                            "idx": 7,
                            "id": "components/grids/pivoting",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/components/grids/pivoting.html"
                        },
                        {
                            "name": "Grid Configurations",
                            "slug": "configurations",
                            "toolkit": "classic",
                            "navTreeName": "Guides",
                            "text": "Grid Configurations",
                            "idx": 8,
                            "id": "components/grids/configurations",
                            "leaf": true,
                            "iconCls": "classic-guide",
                            "href": "guides/components/grids/configurations.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Data Grids",
                    "idx": 7,
                    "id": "components/grids",
                    "iconCls": "fa fa-folder-o",
                    "isIndex": true,
                    "isIndexRelPath": "components/grids/index",
                    "href": "guides/components/grids/"
                },
                {
                    "name": "Pivot Grid",
                    "slug": "pivot_grid",
                    "toolkit": "universal",
                    "tier": "premium",
                    "navTreeName": "Guides",
                    "text": "Pivot Grid",
                    "idx": 8,
                    "id": "components/pivot_grid",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/components/pivot_grid.html"
                },
                {
                    "name": "Trees",
                    "slug": "trees",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Trees",
                    "idx": 9,
                    "id": "components/trees",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/components/trees.html"
                },
                {
                    "name": "Using Components in Grids",
                    "slug": "widgets_widgets_columns",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Using Components in Grids",
                    "idx": 10,
                    "id": "components/widgets_widgets_columns",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/components/widgets_widgets_columns.html"
                }
            ],
            "navTreeName": "Guides",
            "text": "Choosing Components",
            "idx": 4,
            "id": "components",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "App Architecture",
            "slug": "application_architecture",
            "children": [
                {
                    "name": "Intro to App Architecture",
                    "slug": "application_architecture",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Intro to App Architecture",
                    "idx": 1,
                    "id": "application_architecture/application_architecture",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_architecture/application_architecture.html"
                },
                {
                    "name": "Multiple Screens",
                    "slug": "developing_for_multiple_screens_and_environments",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Multiple Screens",
                    "idx": 2,
                    "id": "application_architecture/developing_for_multiple_screens_and_environments",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_architecture/developing_for_multiple_screens_and_environments.html"
                },
                {
                    "name": "View Controllers",
                    "slug": "view_controllers",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "View Controllers",
                    "idx": 3,
                    "id": "application_architecture/view_controllers",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_architecture/view_controllers.html"
                },
                {
                    "name": "View Models & Binding",
                    "slug": "view_models_data_binding",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "View Models & Binding",
                    "idx": 4,
                    "id": "application_architecture/view_models_data_binding",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_architecture/view_models_data_binding.html"
                },
                {
                    "name": "View Model Internals",
                    "slug": "view_model_internals",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "View Model Internals",
                    "idx": 5,
                    "id": "application_architecture/view_model_internals",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_architecture/view_model_internals.html"
                },
                {
                    "name": "Using the Router",
                    "slug": "router",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Using the Router",
                    "idx": 6,
                    "id": "application_architecture/router",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_architecture/router.html"
                }
            ],
            "navTreeName": "Guides",
            "text": "App Architecture",
            "idx": 5,
            "id": "application_architecture",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Core Concepts",
            "slug": "core_concepts",
            "children": [
                {
                    "name": "The Class System",
                    "slug": "classes",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "The Class System",
                    "idx": 1,
                    "id": "core_concepts/classes",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/classes.html"
                },
                {
                    "name": "Layouts and Containers",
                    "slug": "layouts",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Layouts and Containers",
                    "idx": 2,
                    "id": "core_concepts/layouts",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/layouts.html"
                },
                {
                    "name": "Components",
                    "slug": "components",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Components",
                    "idx": 3,
                    "id": "core_concepts/components",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/components.html"
                },
                {
                    "name": "Data Package",
                    "slug": "data_package",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Data Package",
                    "idx": 4,
                    "id": "core_concepts/data_package",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/data_package.html"
                },
                {
                    "name": "Gestures",
                    "slug": "gestures",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Gestures",
                    "idx": 5,
                    "id": "core_concepts/gestures",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/gestures.html"
                },
                {
                    "name": "Events",
                    "slug": "events",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Events",
                    "idx": 6,
                    "id": "core_concepts/events",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/events.html"
                },
                {
                    "name": "Drag and Drop",
                    "slug": "drag_drop",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Drag and Drop",
                    "idx": 7,
                    "id": "core_concepts/drag_drop",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/core_concepts/drag_drop.html"
                },
                {
                    "name": "Modern Drag and Drop",
                    "slug": "modern_drag_drop",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Modern Drag and Drop",
                    "idx": 8,
                    "id": "core_concepts/modern_drag_drop",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/modern_drag_drop.html"
                },
                {
                    "name": "Theming System",
                    "slug": "theming",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Theming System",
                    "idx": 9,
                    "id": "core_concepts/theming",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/theming.html"
                },
                {
                    "name": "Theming in the Modern Toolkit",
                    "slug": "modern_theming",
                    "toolkit": "modern",
                    "navTreeName": "Guides",
                    "text": "Theming in the Modern Toolkit",
                    "idx": 10,
                    "id": "core_concepts/modern_theming",
                    "leaf": true,
                    "iconCls": "modern-guide",
                    "href": "guides/core_concepts/modern_theming.html"
                },
                {
                    "name": "Theming in the Classic Toolkit",
                    "slug": "classic_theming",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Theming in the Classic Toolkit",
                    "idx": 11,
                    "id": "core_concepts/classic_theming",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/core_concepts/classic_theming.html"
                },
                {
                    "name": "Material Theme",
                    "slug": "material_theme",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Material Theme",
                    "idx": 12,
                    "id": "core_concepts/material_theme",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/material_theme.html"
                },
                {
                    "name": "Memory Management",
                    "slug": "memory_management",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Memory Management",
                    "idx": 13,
                    "id": "core_concepts/memory_management",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/memory_management.html"
                },
                {
                    "name": "Using D3 in Ext JS",
                    "slug": "d3",
                    "toolkit": "universal",
                    "tier": "premium",
                    "navTreeName": "Guides",
                    "text": "Using D3 in Ext JS",
                    "idx": 14,
                    "id": "core_concepts/d3",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/d3.html"
                },
                {
                    "name": "Draw Package",
                    "slug": "draw",
                    "children": [
                        {
                            "name": "Draw Package",
                            "slug": "drawing",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Draw Package",
                            "idx": 1,
                            "id": "core_concepts/draw/drawing",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/core_concepts/draw/drawing.html"
                        },
                        {
                            "name": "Creating Images - Pt 1",
                            "slug": "creating_images_with_draw_pt1",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Creating Images - Pt 1",
                            "idx": 2,
                            "id": "core_concepts/draw/creating_images_with_draw_pt1",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/core_concepts/draw/creating_images_with_draw_pt1.html"
                        },
                        {
                            "name": "Creating Images - Pt 2",
                            "slug": "creating_images_with_draw_pt2",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Creating Images - Pt 2",
                            "idx": 3,
                            "id": "core_concepts/draw/creating_images_with_draw_pt2",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/core_concepts/draw/creating_images_with_draw_pt2.html"
                        },
                        {
                            "name": "Creating Images - Pt 3",
                            "slug": "creating_images_with_draw_pt3",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Creating Images - Pt 3",
                            "idx": 4,
                            "id": "core_concepts/draw/creating_images_with_draw_pt3",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/core_concepts/draw/creating_images_with_draw_pt3.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Draw Package",
                    "idx": 15,
                    "id": "core_concepts/draw",
                    "iconCls": "fa fa-folder-o"
                },
                {
                    "name": "Accessibility",
                    "slug": "accessibility",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Accessibility",
                    "idx": 16,
                    "id": "core_concepts/accessibility",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/core_concepts/accessibility.html"
                },
                {
                    "name": "Localization",
                    "slug": "localization",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Localization",
                    "idx": 17,
                    "id": "core_concepts/localization",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/core_concepts/localization.html"
                },
                {
                    "name": "Right to Left in Ext JS",
                    "slug": "rtl",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Right to Left in Ext JS",
                    "idx": 18,
                    "id": "core_concepts/rtl",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/core_concepts/rtl.html"
                },
                {
                    "name": "Sencha Font Packages",
                    "slug": "font_ext",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Sencha Font Packages",
                    "idx": 19,
                    "id": "core_concepts/font_ext",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/core_concepts/font_ext.html"
                },
                {
                    "name": "Tablet Support",
                    "slug": "tablet_support",
                    "toolkit": "classic",
                    "navTreeName": "Guides",
                    "text": "Tablet Support",
                    "idx": 20,
                    "id": "core_concepts/tablet_support",
                    "leaf": true,
                    "iconCls": "classic-guide",
                    "href": "guides/core_concepts/tablet_support.html"
                }
            ],
            "navTreeName": "Guides",
            "text": "Core Concepts",
            "idx": 6,
            "id": "core_concepts",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "App Design",
            "slug": "application_design",
            "children": [
                {
                    "name": "Design with Stencils",
                    "slug": "design_with_stencils",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Design with Stencils",
                    "idx": 1,
                    "id": "application_design/design_with_stencils",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/application_design/design_with_stencils.html"
                }
            ],
            "navTreeName": "Guides",
            "text": "App Design",
            "idx": 7,
            "id": "application_design",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Upgrade Adviser",
            "slug": "upgrade_adviser",
            "children": [
                {
                    "name": "Getting Started",
                    "slug": "getting_started",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Getting Started",
                    "idx": 1,
                    "id": "upgrade_adviser/getting_started",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/upgrade_adviser/getting_started.html"
                },
                {
                    "name": "Custom ESLint Rules",
                    "slug": "docs/rules",
                    "children": [
                        {
                            "name": "no-existing-alias-override",
                            "slug": "no-existing-alias-override",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-existing-alias-override",
                            "idx": 1,
                            "id": "upgrade_adviser/docs/rules/no-existing-alias-override",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-existing-alias-override.html"
                        },
                        {
                            "name": "no-existing-class-override",
                            "slug": "no-existing-class-override",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-existing-class-override",
                            "idx": 2,
                            "id": "upgrade_adviser/docs/rules/no-existing-class-override",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-existing-class-override.html"
                        },
                        {
                            "name": "no-existing-method-override",
                            "slug": "no-existing-method-override",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-existing-method-override",
                            "idx": 3,
                            "id": "upgrade_adviser/docs/rules/no-existing-method-override",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-existing-method-override.html"
                        },
                        {
                            "name": "override-method-call",
                            "slug": "override-method-call",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "override-method-call",
                            "idx": 4,
                            "id": "upgrade_adviser/docs/rules/override-method-call",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/override-method-call.html"
                        },
                        {
                            "name": "no-deprecated-class-usage",
                            "slug": "no-deprecated-class-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-deprecated-class-usage",
                            "idx": 5,
                            "id": "upgrade_adviser/docs/rules/no-deprecated-class-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-deprecated-class-usage.html"
                        },
                        {
                            "name": "no-deprecated-config-usage",
                            "slug": "no-deprecated-config-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-deprecated-config-usage",
                            "idx": 6,
                            "id": "upgrade_adviser/docs/rules/no-deprecated-config-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-deprecated-config-usage.html"
                        },
                        {
                            "name": "no-deprecated-method-call",
                            "slug": "no-deprecated-method-call",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-deprecated-method-call",
                            "idx": 7,
                            "id": "upgrade_adviser/docs/rules/no-deprecated-method-call",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-deprecated-method-call.html"
                        },
                        {
                            "name": "no-deprecated-method-override",
                            "slug": "no-deprecated-method-override",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-deprecated-method-override",
                            "idx": 8,
                            "id": "upgrade_adviser/docs/rules/no-deprecated-method-override",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-deprecated-method-override.html"
                        },
                        {
                            "name": "no-deprecated-property-usage",
                            "slug": "no-deprecated-property-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-deprecated-property-usage",
                            "idx": 9,
                            "id": "upgrade_adviser/docs/rules/no-deprecated-property-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-deprecated-property-usage.html"
                        },
                        {
                            "name": "no-private-class-usage",
                            "slug": "no-private-class-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-private-class-usage",
                            "idx": 10,
                            "id": "upgrade_adviser/docs/rules/no-private-class-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-private-class-usage.html"
                        },
                        {
                            "name": "no-private-config-usage",
                            "slug": "no-private-config-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-private-config-usage",
                            "idx": 11,
                            "id": "upgrade_adviser/docs/rules/no-private-config-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-private-config-usage.html"
                        },
                        {
                            "name": "no-private-method-call",
                            "slug": "no-private-method-call",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-private-method-call",
                            "idx": 12,
                            "id": "upgrade_adviser/docs/rules/no-private-method-call",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-private-method-call.html"
                        },
                        {
                            "name": "no-private-method-override",
                            "slug": "no-private-method-override",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-private-method-override",
                            "idx": 13,
                            "id": "upgrade_adviser/docs/rules/no-private-method-override",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-private-method-override.html"
                        },
                        {
                            "name": "no-private-property-usage",
                            "slug": "no-private-property-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-private-property-usage",
                            "idx": 14,
                            "id": "upgrade_adviser/docs/rules/no-private-property-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-private-property-usage.html"
                        },
                        {
                            "name": "no-removed-class-usage",
                            "slug": "no-removed-class-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-removed-class-usage",
                            "idx": 15,
                            "id": "upgrade_adviser/docs/rules/no-removed-class-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-removed-class-usage.html"
                        },
                        {
                            "name": "no-removed-config-usage",
                            "slug": "no-removed-config-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-removed-config-usage",
                            "idx": 16,
                            "id": "upgrade_adviser/docs/rules/no-removed-config-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-removed-config-usage.html"
                        },
                        {
                            "name": "no-removed-method-call",
                            "slug": "no-removed-method-call",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-removed-method-call",
                            "idx": 17,
                            "id": "upgrade_adviser/docs/rules/no-removed-method-call",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-removed-method-call.html"
                        },
                        {
                            "name": "no-removed-method-override",
                            "slug": "no-removed-method-override",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-removed-method-override",
                            "idx": 18,
                            "id": "upgrade_adviser/docs/rules/no-removed-method-override",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-removed-method-override.html"
                        },
                        {
                            "name": "no-removed-property-usage",
                            "slug": "no-removed-property-usage",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "no-removed-property-usage",
                            "idx": 19,
                            "id": "upgrade_adviser/docs/rules/no-removed-property-usage",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/upgrade_adviser/docs/rules/no-removed-property-usage.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Custom ESLint Rules",
                    "idx": 2,
                    "id": "upgrade_adviser/docs/rules",
                    "iconCls": "fa fa-folder-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "Upgrade Adviser",
            "idx": 8,
            "id": "upgrade_adviser",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Backend Connectors",
            "slug": "backend_connectors",
            "children": [
                {
                    "name": "SOAP Services",
                    "slug": "soap",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "SOAP Services",
                    "idx": 1,
                    "id": "backend_connectors/soap",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/backend_connectors/soap.html"
                },
                {
                    "name": "AMF Data Sources",
                    "slug": "amf",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "AMF Data Sources",
                    "idx": 2,
                    "id": "backend_connectors/amf",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/backend_connectors/amf.html"
                },
                {
                    "name": "Ext Direct",
                    "slug": "direct",
                    "children": [
                        {
                            "name": "Ext Direct Specification",
                            "slug": "specification",
                            "toolkit": "universal",
                            "navTreeName": "Guides",
                            "text": "Ext Direct Specification",
                            "idx": 1,
                            "id": "backend_connectors/direct/specification",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/backend_connectors/direct/specification.html"
                        },
                        {
                            "name": "Using MySQL and PHP",
                            "slug": "mysql_php",
                            "toolkit": "classic",
                            "navTreeName": "Guides",
                            "text": "Using MySQL and PHP",
                            "idx": 2,
                            "id": "backend_connectors/direct/mysql_php",
                            "leaf": true,
                            "iconCls": "classic-guide",
                            "href": "guides/backend_connectors/direct/mysql_php.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Ext Direct",
                    "idx": 3,
                    "id": "backend_connectors/direct",
                    "iconCls": "fa fa-folder-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "Backend Connectors",
            "idx": 9,
            "id": "backend_connectors",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "App Build Tools - npm & Cmd",
            "slug": "using_systems",
            "children": [
                {
                    "name": "Using Cmd",
                    "slug": "using_cmd",
                    "children": [
                        {
                            "name": "Using Cmd",
                            "slug": "using_cmd",
                            "navTreeName": "Guides",
                            "text": "Using Cmd",
                            "idx": 1,
                            "id": "using_systems/using_cmd/using_cmd",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_cmd/using_cmd.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Using Cmd",
                    "idx": 1,
                    "id": "using_systems/using_cmd",
                    "iconCls": "fa fa-folder-o"
                },
                {
                    "name": "Using npm",
                    "slug": "using_npm",
                    "children": [
                        {
                            "name": "What's New",
                            "slug": "whats_new",
                            "navTreeName": "Guides",
                            "text": "What's New",
                            "idx": 1,
                            "id": "using_systems/using_npm/whats_new",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/whats_new.html"
                        },
                        {
                            "name": "Using Npm",
                            "slug": "using_npm",
                            "navTreeName": "Guides",
                            "text": "Using Npm",
                            "idx": 2,
                            "id": "using_systems/using_npm/using_npm",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/using_npm.html"
                        },
                        {
                            "name": "npm Repository Access",
                            "slug": "npm_repo_access",
                            "navTreeName": "Guides",
                            "text": "npm Repository Access",
                            "idx": 3,
                            "id": "using_systems/using_npm/npm_repo_access",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/npm_repo_access.html"
                        },
                        {
                            "name": "Ext JS npm Packages",
                            "slug": "extjs_packages",
                            "navTreeName": "Guides",
                            "text": "Ext JS npm Packages",
                            "idx": 4,
                            "id": "using_systems/using_npm/extjs_packages",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/extjs_packages.html"
                        },
                        {
                            "name": "Migrate Existing Ext JS Apps",
                            "slug": "npm_migrate",
                            "navTreeName": "Guides",
                            "text": "Migrate Existing Ext JS Apps",
                            "idx": 5,
                            "id": "using_systems/using_npm/npm_migrate",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/npm_migrate.html"
                        },
                        {
                            "name": "Upgrading Open Tooling Apps",
                            "slug": "extmovetolatest",
                            "navTreeName": "Guides",
                            "text": "Upgrading Open Tooling Apps",
                            "idx": 6,
                            "id": "using_systems/using_npm/extmovetolatest",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/extmovetolatest.html"
                        },
                        {
                            "name": "Open Tooling - Webpack + Sencha Cmd Configuration",
                            "slug": "configuring_webpack",
                            "navTreeName": "Guides",
                            "text": "Open Tooling - Webpack + Sencha Cmd Configuration",
                            "idx": 7,
                            "id": "using_systems/using_npm/configuring_webpack",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/configuring_webpack.html"
                        },
                        {
                            "name": "npm Troubleshooting",
                            "slug": "npm_help",
                            "navTreeName": "Guides",
                            "text": "npm Troubleshooting",
                            "idx": 8,
                            "id": "using_systems/using_npm/npm_help",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/npm_help.html"
                        },
                        {
                            "name": "CLI Reference",
                            "slug": "cli_reference",
                            "navTreeName": "Guides",
                            "text": "CLI Reference",
                            "idx": 9,
                            "id": "using_systems/using_npm/cli_reference",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/cli_reference.html"
                        },
                        {
                            "name": "Adding npm Packages",
                            "slug": "adding_npm_packages",
                            "navTreeName": "Guides",
                            "text": "Adding npm Packages",
                            "idx": 10,
                            "id": "using_systems/using_npm/adding_npm_packages",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/using_systems/using_npm/adding_npm_packages.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Using npm",
                    "idx": 2,
                    "id": "using_systems/using_npm",
                    "iconCls": "fa fa-folder-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "App Build Tools - npm & Cmd",
            "idx": 10,
            "id": "using_systems",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Other Resources",
            "slug": "other_resources",
            "children": [
                {
                    "name": "Ext JS - FAQ",
                    "slug": "extjs_faq",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Ext JS - FAQ",
                    "idx": 1,
                    "id": "other_resources/extjs_faq",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/other_resources/extjs_faq.html"
                },
                {
                    "name": "Basics of OOP",
                    "slug": "oop_concepts",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Basics of OOP",
                    "idx": 2,
                    "id": "other_resources/oop_concepts",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/other_resources/oop_concepts.html"
                },
                {
                    "name": "Ext JS Ecosystem",
                    "slug": "ecosystem",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Ext JS Ecosystem",
                    "idx": 3,
                    "id": "other_resources/ecosystem",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/other_resources/ecosystem.html"
                },
                {
                    "name": "Use of eval Function in Sencha Ext Js",
                    "slug": "use_eval_func",
                    "toolkit": "universal",
                    "navTreeName": "Guides",
                    "text": "Use of eval Function in Sencha Ext Js",
                    "idx": 4,
                    "id": "other_resources/use_eval_func",
                    "leaf": true,
                    "iconCls": "fa fa-file-text-o",
                    "href": "guides/other_resources/use_eval_func.html"
                }
            ],
            "navTreeName": "Guides",
            "text": "Other Resources",
            "idx": 11,
            "id": "other_resources",
            "iconCls": "fa fa-folder-o"
        },
        {
            "name": "Supported Browsers",
            "slug": "supported_browsers",
            "toolkit": "universal",
            "navTreeName": "Guides",
            "text": "Supported Browsers",
            "idx": 12,
            "id": "supported_browsers",
            "leaf": true,
            "iconCls": "fa fa-file-text-o",
            "href": "guides/supported_browsers.html"
        },
        {
            "name": "Tutorials",
            "slug": "tutorials",
            "children": [
                {
                    "name": "Grid Tutorial",
                    "slug": "grid_tutorial",
                    "children": [
                        {
                            "name": "Grid Tutorials",
                            "slug": "grid_tutorials",
                            "navTreeName": "Guides",
                            "text": "Grid Tutorials",
                            "idx": 1,
                            "id": "tutorials/grid_tutorial/grid_tutorials",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/tutorials/grid_tutorial/grid_tutorials.html"
                        },
                        {
                            "name": "Topics",
                            "slug": "topics",
                            "navTreeName": "Guides",
                            "text": "Topics",
                            "idx": 2,
                            "id": "tutorials/grid_tutorial/topics",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/tutorials/grid_tutorial/topics.html"
                        },
                        {
                            "name": "Feature List",
                            "slug": "feature_list",
                            "navTreeName": "Guides",
                            "text": "Feature List",
                            "idx": 3,
                            "id": "tutorials/grid_tutorial/feature_list",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/tutorials/grid_tutorial/feature_list.html"
                        },
                        {
                            "name": "Basics",
                            "slug": "basics",
                            "children": [
                                {
                                    "name": "Introduction",
                                    "slug": "introduction",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/basics/introduction/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/introduction/introduction.html"
                                        },
                                        {
                                            "name": "What's a Store?",
                                            "slug": "whats_a_store",
                                            "navTreeName": "Guides",
                                            "text": "What's a Store?",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/basics/introduction/whats_a_store",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/introduction/whats_a_store.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Introduction",
                                    "idx": 1,
                                    "id": "tutorials/grid_tutorial/basics/introduction",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Columns",
                                    "slug": "columns",
                                    "children": [
                                        {
                                            "name": "DataIndex and text",
                                            "slug": "dataindex_and_text",
                                            "navTreeName": "Guides",
                                            "text": "DataIndex and text",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/basics/columns/dataindex_and_text",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/dataindex_and_text.html"
                                        },
                                        {
                                            "name": "Formatter and Renderer",
                                            "slug": "formatter_and_renderer",
                                            "navTreeName": "Guides",
                                            "text": "Formatter and Renderer",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/basics/columns/formatter_and_renderer",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/formatter_and_renderer.html"
                                        },
                                        {
                                            "name": "tpl",
                                            "slug": "tpl",
                                            "navTreeName": "Guides",
                                            "text": "tpl",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/basics/columns/tpl",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/tpl.html"
                                        },
                                        {
                                            "name": "Column Types",
                                            "slug": "column_types",
                                            "navTreeName": "Guides",
                                            "text": "Column Types",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/basics/columns/column_types",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/column_types.html"
                                        },
                                        {
                                            "name": "Example",
                                            "slug": "example",
                                            "navTreeName": "Guides",
                                            "text": "Example",
                                            "idx": 5,
                                            "id": "tutorials/grid_tutorial/basics/columns/example",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/example.html"
                                        },
                                        {
                                            "name": "Row Numberer",
                                            "slug": "row_numberer",
                                            "navTreeName": "Guides",
                                            "text": "Row Numberer",
                                            "idx": 6,
                                            "id": "tutorials/grid_tutorial/basics/columns/row_numberer",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/row_numberer.html"
                                        },
                                        {
                                            "name": "More Configs",
                                            "slug": "more_configs",
                                            "navTreeName": "Guides",
                                            "text": "More Configs",
                                            "idx": 7,
                                            "id": "tutorials/grid_tutorial/basics/columns/more_configs",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/columns/more_configs.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Columns",
                                    "idx": 2,
                                    "id": "tutorials/grid_tutorial/basics/columns",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Events and Binding",
                                    "slug": "events_and_binding",
                                    "children": [
                                        {
                                            "name": "Events",
                                            "slug": "events",
                                            "navTreeName": "Guides",
                                            "text": "Events",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/basics/events_and_binding/events",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/events_and_binding/events.html"
                                        },
                                        {
                                            "name": "Binding",
                                            "slug": "binding",
                                            "navTreeName": "Guides",
                                            "text": "Binding",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/basics/events_and_binding/binding",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/events_and_binding/binding.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Events and Binding",
                                    "idx": 3,
                                    "id": "tutorials/grid_tutorial/basics/events_and_binding",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Menus",
                                    "slug": "menus",
                                    "children": [
                                        {
                                            "name": "columnMenu and columnsMenuItem",
                                            "slug": "columnmenu_and_columnsmenuitem",
                                            "navTreeName": "Guides",
                                            "text": "columnMenu and columnsMenuItem",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/basics/menus/columnmenu_and_columnsmenuitem",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/menus/columnmenu_and_columnsmenuitem.html"
                                        },
                                        {
                                            "name": "Example",
                                            "slug": "example",
                                            "navTreeName": "Guides",
                                            "text": "Example",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/basics/menus/example",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/menus/example.html"
                                        },
                                        {
                                            "name": "Menu",
                                            "slug": "menu",
                                            "navTreeName": "Guides",
                                            "text": "Menu",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/basics/menus/menu",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/menus/menu.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Menus",
                                    "idx": 4,
                                    "id": "tutorials/grid_tutorial/basics/menus",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Selection Model",
                                    "slug": "selection_model",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/basics/selection_model/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/selection_model/introduction.html"
                                        },
                                        {
                                            "name": "Configuration",
                                            "slug": "configuration",
                                            "navTreeName": "Guides",
                                            "text": "Configuration",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/basics/selection_model/configuration",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/basics/selection_model/configuration.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Selection Model",
                                    "idx": 5,
                                    "id": "tutorials/grid_tutorial/basics/selection_model",
                                    "iconCls": "fa fa-folder-o"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Basics",
                            "idx": 4,
                            "id": "tutorials/grid_tutorial/basics",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "Data Manipulation",
                            "slug": "data_manipulation",
                            "children": [
                                {
                                    "name": "Introduction",
                                    "slug": "introduction",
                                    "navTreeName": "Guides",
                                    "text": "Introduction",
                                    "idx": 1,
                                    "id": "tutorials/grid_tutorial/data_manipulation/introduction",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/grid_tutorial/data_manipulation/introduction.html"
                                },
                                {
                                    "name": "Sorting",
                                    "slug": "sorting",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/data_manipulation/sorting/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/sorting/introduction.html"
                                        },
                                        {
                                            "name": "Column Config",
                                            "slug": "column_config",
                                            "navTreeName": "Guides",
                                            "text": "Column Config",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/data_manipulation/sorting/column_config",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/sorting/column_config.html"
                                        },
                                        {
                                            "name": "Sorting on a Single Column",
                                            "slug": "sorting_on_a_single_column",
                                            "navTreeName": "Guides",
                                            "text": "Sorting on a Single Column",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/data_manipulation/sorting/sorting_on_a_single_column",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/sorting/sorting_on_a_single_column.html"
                                        },
                                        {
                                            "name": "Sorting on Multiple Columns",
                                            "slug": "sorting_on_multiple_columns",
                                            "navTreeName": "Guides",
                                            "text": "Sorting on Multiple Columns",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/data_manipulation/sorting/sorting_on_multiple_columns",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/sorting/sorting_on_multiple_columns.html"
                                        },
                                        {
                                            "name": "Procedurally Adding Sorters",
                                            "slug": "procedurally_adding_sorters",
                                            "navTreeName": "Guides",
                                            "text": "Procedurally Adding Sorters",
                                            "idx": 5,
                                            "id": "tutorials/grid_tutorial/data_manipulation/sorting/procedurally_adding_sorters",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/sorting/procedurally_adding_sorters.html"
                                        },
                                        {
                                            "name": "Sorting Approaches Example",
                                            "slug": "sorting_approaches_example",
                                            "navTreeName": "Guides",
                                            "text": "Sorting Approaches Example",
                                            "idx": 6,
                                            "id": "tutorials/grid_tutorial/data_manipulation/sorting/sorting_approaches_example",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/sorting/sorting_approaches_example.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Sorting",
                                    "idx": 2,
                                    "id": "tutorials/grid_tutorial/data_manipulation/sorting",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Filtering",
                                    "slug": "filtering",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/data_manipulation/filtering/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/filtering/introduction.html"
                                        },
                                        {
                                            "name": "Using the gridfilters Plugin",
                                            "slug": "using_the_gridfilters_plugin",
                                            "navTreeName": "Guides",
                                            "text": "Using the gridfilters Plugin",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/data_manipulation/filtering/using_the_gridfilters_plugin",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/filtering/using_the_gridfilters_plugin.html"
                                        },
                                        {
                                            "name": "Under Program Control",
                                            "slug": "under_program_control",
                                            "navTreeName": "Guides",
                                            "text": "Under Program Control",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/data_manipulation/filtering/under_program_control",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/filtering/under_program_control.html"
                                        },
                                        {
                                            "name": "Filter Binding",
                                            "slug": "filter_binding",
                                            "navTreeName": "Guides",
                                            "text": "Filter Binding",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/data_manipulation/filtering/filter_binding",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/filtering/filter_binding.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Filtering",
                                    "idx": 3,
                                    "id": "tutorials/grid_tutorial/data_manipulation/filtering",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Grouping",
                                    "slug": "grouping",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/data_manipulation/grouping/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/grouping/introduction.html"
                                        },
                                        {
                                            "name": "Example",
                                            "slug": "example",
                                            "navTreeName": "Guides",
                                            "text": "Example",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/data_manipulation/grouping/example",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/grouping/example.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Grouping",
                                    "idx": 4,
                                    "id": "tutorials/grid_tutorial/data_manipulation/grouping",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Chained Stores",
                                    "slug": "chained_stores",
                                    "children": [
                                        {
                                            "name": "Ext.data.ChainedStore",
                                            "slug": "ext.data.chainedstore",
                                            "navTreeName": "Guides",
                                            "text": "Ext.data.ChainedStore",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/data_manipulation/chained_stores/ext.data.chainedstore",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/chained_stores/ext.data.chainedstore.html"
                                        },
                                        {
                                            "name": "Chained Stores Use the Source's Records",
                                            "slug": "chained_stores_use_the_sources_records",
                                            "navTreeName": "Guides",
                                            "text": "Chained Stores Use the Source's Records",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/data_manipulation/chained_stores/chained_stores_use_the_sources_records",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/chained_stores/chained_stores_use_the_sources_records.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Chained Stores",
                                    "idx": 5,
                                    "id": "tutorials/grid_tutorial/data_manipulation/chained_stores",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Plugins",
                                    "slug": "plugins",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/introduction.html"
                                        },
                                        {
                                            "name": "Grid_Plugins",
                                            "slug": "grid_plugins",
                                            "navTreeName": "Guides",
                                            "text": "Grid_Plugins",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/grid_plugins",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/grid_plugins.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.Editable",
                                            "slug": "ext.grid.plugin.editable",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.Editable",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.editable",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.editable.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.CellEditing",
                                            "slug": "ext.grid.plugin.cellediting",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.CellEditing",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.cellediting",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.cellediting.html"
                                        },
                                        {
                                            "name": "Ext.grid.rowedit.Plugin",
                                            "slug": "ext.grid.rowedit.plugin",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.rowedit.Plugin",
                                            "idx": 5,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.rowedit.plugin",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.rowedit.plugin.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.RowExpander",
                                            "slug": "ext.grid.plugin.rowexpander",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.RowExpander",
                                            "idx": 6,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.rowexpander",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.rowexpander.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.RowOperations",
                                            "slug": "ext.grid.plugin.rowoperations",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.RowOperations",
                                            "idx": 7,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.rowoperations",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.rowoperations.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.ViewOptions",
                                            "slug": "ext.grid.plugin.viewoptions",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.ViewOptions",
                                            "idx": 8,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.viewoptions",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.viewoptions.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.RowDragDrop",
                                            "slug": "ext.grid.plugin.rowdragdrop",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.RowDragDrop",
                                            "idx": 9,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.rowdragdrop",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.rowdragdrop.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.Exporter",
                                            "slug": "ext.grid.plugin.exporter",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.Exporter",
                                            "idx": 10,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.exporter",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.exporter.html"
                                        },
                                        {
                                            "name": "Ext.grid.plugin.Summary",
                                            "slug": "ext.grid.plugin.summary",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.plugin.Summary",
                                            "idx": 11,
                                            "id": "tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.summary",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/data_manipulation/plugins/ext.grid.plugin.summary.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Plugins",
                                    "idx": 6,
                                    "id": "tutorials/grid_tutorial/data_manipulation/plugins",
                                    "iconCls": "fa fa-folder-o"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Data Manipulation",
                            "idx": 5,
                            "id": "tutorials/grid_tutorial/data_manipulation",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "Advanced",
                            "slug": "advanced",
                            "children": [
                                {
                                    "name": "Introduction",
                                    "slug": "introduction",
                                    "navTreeName": "Guides",
                                    "text": "Introduction",
                                    "idx": 1,
                                    "id": "tutorials/grid_tutorial/advanced/introduction",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/grid_tutorial/advanced/introduction.html"
                                },
                                {
                                    "name": "Cells",
                                    "slug": "cells",
                                    "children": [
                                        {
                                            "name": "Columns Have an Associated Cell",
                                            "slug": "columns_have_an_associated_cell",
                                            "navTreeName": "Guides",
                                            "text": "Columns Have an Associated Cell",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/advanced/cells/columns_have_an_associated_cell",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/columns_have_an_associated_cell.html"
                                        },
                                        {
                                            "name": "Example",
                                            "slug": "example",
                                            "navTreeName": "Guides",
                                            "text": "Example",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/advanced/cells/example",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/example.html"
                                        },
                                        {
                                            "name": "High-Level UML",
                                            "slug": "high-level_uml",
                                            "navTreeName": "Guides",
                                            "text": "High-Level UML",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/advanced/cells/high-level_uml",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/high-level_uml.html"
                                        },
                                        {
                                            "name": "Cell Types",
                                            "slug": "cell_types",
                                            "navTreeName": "Guides",
                                            "text": "Cell Types",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/advanced/cells/cell_types",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/cell_types.html"
                                        },
                                        {
                                            "name": "Detailed UML",
                                            "slug": "detailed_uml",
                                            "navTreeName": "Guides",
                                            "text": "Detailed UML",
                                            "idx": 5,
                                            "id": "tutorials/grid_tutorial/advanced/cells/detailed_uml",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/detailed_uml.html"
                                        },
                                        {
                                            "name": "Ext.grid.cell.Cell",
                                            "slug": "ext.grid.cell.cell",
                                            "children": [
                                                {
                                                    "name": "Introduction",
                                                    "slug": "introduction",
                                                    "navTreeName": "Guides",
                                                    "text": "Introduction",
                                                    "idx": 1,
                                                    "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/introduction",
                                                    "leaf": true,
                                                    "iconCls": "fa fa-file-text-o",
                                                    "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/introduction.html"
                                                },
                                                {
                                                    "name": "gridcolumn uses gridcell",
                                                    "slug": "gridcolumn_uses_gridcell",
                                                    "navTreeName": "Guides",
                                                    "text": "gridcolumn uses gridcell",
                                                    "idx": 2,
                                                    "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/gridcolumn_uses_gridcell",
                                                    "leaf": true,
                                                    "iconCls": "fa fa-file-text-o",
                                                    "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/gridcolumn_uses_gridcell.html"
                                                },
                                                {
                                                    "name": "Default Rendering",
                                                    "slug": "default_rendering",
                                                    "navTreeName": "Guides",
                                                    "text": "Default Rendering",
                                                    "idx": 3,
                                                    "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/default_rendering",
                                                    "leaf": true,
                                                    "iconCls": "fa fa-file-text-o",
                                                    "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/default_rendering.html"
                                                },
                                                {
                                                    "name": "tpl",
                                                    "slug": "tpl",
                                                    "navTreeName": "Guides",
                                                    "text": "tpl",
                                                    "idx": 4,
                                                    "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/tpl",
                                                    "leaf": true,
                                                    "iconCls": "fa fa-file-text-o",
                                                    "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/tpl.html"
                                                },
                                                {
                                                    "name": "Renderer",
                                                    "slug": "renderer",
                                                    "navTreeName": "Guides",
                                                    "text": "Renderer",
                                                    "idx": 5,
                                                    "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/renderer",
                                                    "leaf": true,
                                                    "iconCls": "fa fa-file-text-o",
                                                    "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/renderer.html"
                                                },
                                                {
                                                    "name": "Formatter",
                                                    "slug": "formatter",
                                                    "navTreeName": "Guides",
                                                    "text": "Formatter",
                                                    "idx": 6,
                                                    "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/formatter",
                                                    "leaf": true,
                                                    "iconCls": "fa fa-file-text-o",
                                                    "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell/formatter.html"
                                                }
                                            ],
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.cell.Cell",
                                            "idx": 6,
                                            "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.cell",
                                            "iconCls": "fa fa-folder-o"
                                        },
                                        {
                                            "name": "Ext.grid.cell.Date",
                                            "slug": "ext.grid.cell.date",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.cell.Date",
                                            "idx": 7,
                                            "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.date",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.date.html"
                                        },
                                        {
                                            "name": "Ext.grid.cell.Number",
                                            "slug": "ext.grid.cell.number",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.cell.Number",
                                            "idx": 8,
                                            "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.number",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.number.html"
                                        },
                                        {
                                            "name": "Ext.grid.cell.Boolean",
                                            "slug": "ext.grid.cell.boolean",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.cell.Boolean",
                                            "idx": 9,
                                            "id": "tutorials/grid_tutorial/advanced/cells/ext.grid.cell.boolean",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cells/ext.grid.cell.boolean.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Cells",
                                    "idx": 2,
                                    "id": "tutorials/grid_tutorial/advanced/cells",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Cells are Toolable",
                                    "slug": "cells_are_toolable",
                                    "navTreeName": "Guides",
                                    "text": "Cells are Toolable",
                                    "idx": 3,
                                    "id": "tutorials/grid_tutorial/advanced/cells_are_toolable",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/grid_tutorial/advanced/cells_are_toolable.html"
                                },
                                {
                                    "name": "Cell Binding",
                                    "slug": "cell_binding",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/advanced/cell_binding/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cell_binding/introduction.html"
                                        },
                                        {
                                            "name": "Example",
                                            "slug": "example",
                                            "navTreeName": "Guides",
                                            "text": "Example",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/advanced/cell_binding/example",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cell_binding/example.html"
                                        },
                                        {
                                            "name": "Example",
                                            "slug": "example2",
                                            "navTreeName": "Guides",
                                            "text": "Example",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/advanced/cell_binding/example2",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/cell_binding/example2.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Cell Binding",
                                    "idx": 4,
                                    "id": "tutorials/grid_tutorial/advanced/cell_binding",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Grids Sparklines and Charts",
                                    "slug": "grids_sparklines_and_charts",
                                    "children": [
                                        {
                                            "name": "Introduction",
                                            "slug": "introduction",
                                            "navTreeName": "Guides",
                                            "text": "Introduction",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/introduction",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/introduction.html"
                                        },
                                        {
                                            "name": "Ext.grid.cell.Widget",
                                            "slug": "ext.grid.cell.widget",
                                            "navTreeName": "Guides",
                                            "text": "Ext.grid.cell.Widget",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/ext.grid.cell.widget",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/ext.grid.cell.widget.html"
                                        },
                                        {
                                            "name": "Sparklines",
                                            "slug": "sparklines",
                                            "navTreeName": "Guides",
                                            "text": "Sparklines",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/sparklines",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/sparklines.html"
                                        },
                                        {
                                            "name": "Sparklines + grids = interesting",
                                            "slug": "sparklines_grids_interesting",
                                            "navTreeName": "Guides",
                                            "text": "Sparklines + grids = interesting",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/sparklines_grids_interesting",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/sparklines_grids_interesting.html"
                                        },
                                        {
                                            "name": "Charts Reveal Information",
                                            "slug": "charts_reveal_information",
                                            "navTreeName": "Guides",
                                            "text": "Charts Reveal Information",
                                            "idx": 5,
                                            "id": "tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/charts_reveal_information",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/grids_sparklines_and_charts/charts_reveal_information.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Grids Sparklines and Charts",
                                    "idx": 5,
                                    "id": "tutorials/grid_tutorial/advanced/grids_sparklines_and_charts",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Other Cool Things",
                                    "slug": "other_cool_things",
                                    "children": [
                                        {
                                            "name": "Locked Columns",
                                            "slug": "locked_columns",
                                            "navTreeName": "Guides",
                                            "text": "Locked Columns",
                                            "idx": 1,
                                            "id": "tutorials/grid_tutorial/advanced/other_cool_things/locked_columns",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/other_cool_things/locked_columns.html"
                                        },
                                        {
                                            "name": "Column Spanning",
                                            "slug": "column_spanning",
                                            "navTreeName": "Guides",
                                            "text": "Column Spanning",
                                            "idx": 2,
                                            "id": "tutorials/grid_tutorial/advanced/other_cool_things/column_spanning",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/other_cool_things/column_spanning.html"
                                        },
                                        {
                                            "name": "Group Header Configuration",
                                            "slug": "group_header_configuration",
                                            "navTreeName": "Guides",
                                            "text": "Group Header Configuration",
                                            "idx": 3,
                                            "id": "tutorials/grid_tutorial/advanced/other_cool_things/group_header_configuration",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/other_cool_things/group_header_configuration.html"
                                        },
                                        {
                                            "name": "Infinite Scrolling",
                                            "slug": "infinite_scrolling",
                                            "navTreeName": "Guides",
                                            "text": "Infinite Scrolling",
                                            "idx": 4,
                                            "id": "tutorials/grid_tutorial/advanced/other_cool_things/infinite_scrolling",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/other_cool_things/infinite_scrolling.html"
                                        },
                                        {
                                            "name": "Theming",
                                            "slug": "theming",
                                            "navTreeName": "Guides",
                                            "text": "Theming",
                                            "idx": 5,
                                            "id": "tutorials/grid_tutorial/advanced/other_cool_things/theming",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/grid_tutorial/advanced/other_cool_things/theming.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Other Cool Things",
                                    "idx": 6,
                                    "id": "tutorials/grid_tutorial/advanced/other_cool_things",
                                    "iconCls": "fa fa-folder-o"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Advanced",
                            "idx": 6,
                            "id": "tutorials/grid_tutorial/advanced",
                            "iconCls": "fa fa-folder-o"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Grid Tutorial",
                    "idx": 1,
                    "id": "tutorials/grid_tutorial",
                    "iconCls": "fa fa-folder-o"
                },
                {
                    "name": "Login App",
                    "slug": "login_app",
                    "children": [
                        {
                            "name": "Login App",
                            "slug": "login_app",
                            "toolkit": "classic",
                            "navTreeName": "Guides",
                            "text": "Login App",
                            "idx": 1,
                            "id": "tutorials/login_app/login_app",
                            "leaf": true,
                            "iconCls": "classic-guide",
                            "href": "guides/tutorials/login_app/login_app.html"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Login App",
                    "idx": 2,
                    "id": "tutorials/login_app",
                    "iconCls": "fa fa-folder-o"
                },
                {
                    "name": "Quick Start",
                    "slug": "quick_start",
                    "children": [
                        {
                            "name": "What You Will Be Coding",
                            "slug": "What_You_Will_Be_Coding",
                            "summary": "",
                            "navTreeName": "Guides",
                            "text": "What You Will Be Coding",
                            "idx": 1,
                            "id": "tutorials/quick_start/What_You_Will_Be_Coding",
                            "leaf": true,
                            "iconCls": "fa fa-file-text-o",
                            "href": "guides/tutorials/quick_start/What_You_Will_Be_Coding.html"
                        },
                        {
                            "name": "Start Coding the App: Tab Panel",
                            "slug": "Set_Up_Start_Coding_the_App",
                            "summary": "",
                            "children": [
                                {
                                    "name": "Anatomy",
                                    "slug": "Anatomy",
                                    "summary": "",
                                    "children": [
                                        {
                                            "name": "Basic Definitions and Vocabulary",
                                            "slug": "Basic_Definitions_and_Vocabulary",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Basic Definitions and Vocabulary",
                                            "idx": 1,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Basic_Definitions_and_Vocabulary",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Basic_Definitions_and_Vocabulary.html"
                                        },
                                        {
                                            "name": "View Package",
                                            "slug": "View_Bundle",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "View Package",
                                            "idx": 2,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/View_Bundle",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/View_Bundle.html"
                                        },
                                        {
                                            "name": "Model",
                                            "slug": "Model",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Model",
                                            "idx": 3,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Model",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Model.html"
                                        },
                                        {
                                            "name": "Tab Panel",
                                            "slug": "Tab_Panel",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Tab Panel",
                                            "idx": 4,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Tab_Panel",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Tab_Panel.html"
                                        },
                                        {
                                            "name": "Dataview",
                                            "slug": "Dataview",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Dataview",
                                            "idx": 5,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Dataview",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Dataview.html"
                                        },
                                        {
                                            "name": "Grid",
                                            "slug": "Grid",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Grid",
                                            "idx": 6,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Grid",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Grid.html"
                                        },
                                        {
                                            "name": "Dialog & Video",
                                            "slug": "Dialog_&_Video",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Dialog & Video",
                                            "idx": 7,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Dialog_&_Video",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Dialog_&_Video.html"
                                        },
                                        {
                                            "name": "Modern View Summary",
                                            "slug": "Modern_View_Summary",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Modern View Summary",
                                            "idx": 8,
                                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Modern_View_Summary",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy/Modern_View_Summary.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Anatomy",
                                    "idx": 1,
                                    "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Anatomy",
                                    "iconCls": "fa fa-folder-o"
                                },
                                {
                                    "name": "Lab: NPM Package Sencha ExtGen",
                                    "slug": "Lab_NPM_Package_Sencha_ExtGen",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Lab: NPM Package Sencha ExtGen",
                                    "idx": 2,
                                    "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Lab_NPM_Package_Sencha_ExtGen",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Lab_NPM_Package_Sencha_ExtGen.html"
                                },
                                {
                                    "name": "Review the Development Build",
                                    "slug": "Review_the_Development_Build",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Review the Development Build",
                                    "idx": 3,
                                    "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Review_the_Development_Build",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Review_the_Development_Build.html"
                                },
                                {
                                    "name": "What's All That Stuff?",
                                    "slug": "Whats_All_That_Stuff",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "What's All That Stuff?",
                                    "idx": 4,
                                    "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Whats_All_That_Stuff",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Whats_All_That_Stuff.html"
                                },
                                {
                                    "name": "Lab: Stub Out the App",
                                    "slug": "Lab_Stub_Out_the_App",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Lab: Stub Out the App",
                                    "idx": 5,
                                    "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App/Lab_Stub_Out_the_App",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Set_Up_Start_Coding_the_App/Lab_Stub_Out_the_App.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Start Coding the App: Tab Panel",
                            "idx": 2,
                            "id": "tutorials/quick_start/Set_Up_Start_Coding_the_App",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "Fetch the Data",
                            "slug": "Fetch_the_Data",
                            "summary": "",
                            "children": [
                                {
                                    "name": "The Data Feed",
                                    "slug": "The_Data_Feed",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "The Data Feed",
                                    "idx": 1,
                                    "id": "tutorials/quick_start/Fetch_the_Data/The_Data_Feed",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Fetch_the_Data/The_Data_Feed.html"
                                },
                                {
                                    "name": "The Data is Nested",
                                    "slug": "The_Data_is_Nested",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "The Data is Nested",
                                    "idx": 2,
                                    "id": "tutorials/quick_start/Fetch_the_Data/The_Data_is_Nested",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Fetch_the_Data/The_Data_is_Nested.html"
                                },
                                {
                                    "name": "Ext.data.field.Field: Mapping",
                                    "slug": "Ext.data.field.Field_Mapping",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Ext.data.field.Field: Mapping",
                                    "idx": 3,
                                    "id": "tutorials/quick_start/Fetch_the_Data/Ext.data.field.Field_Mapping",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Fetch_the_Data/Ext.data.field.Field_Mapping.html"
                                },
                                {
                                    "name": "Lab: Tunes — Fetch the Data",
                                    "slug": "Lab_Tunes_Fetch_the_Data",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Lab: Tunes — Fetch the Data",
                                    "idx": 4,
                                    "id": "tutorials/quick_start/Fetch_the_Data/Lab_Tunes_Fetch_the_Data",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Fetch_the_Data/Lab_Tunes_Fetch_the_Data.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Fetch the Data",
                            "idx": 3,
                            "id": "tutorials/quick_start/Fetch_the_Data",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "First Tab: Code the Thumbnails",
                            "slug": "First_Tab_Code_the_Thumbnails",
                            "summary": "",
                            "children": [
                                {
                                    "name": "Ext.dataview.DataView",
                                    "slug": "Ext.dataview.DataView",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Ext.dataview.DataView",
                                    "idx": 1,
                                    "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Ext.dataview.DataView",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/First_Tab_Code_the_Thumbnails/Ext.dataview.DataView.html"
                                },
                                {
                                    "name": "Lab: Tunes - Show the Dataview",
                                    "slug": "Lab_Tunes_Show_the_Dataview",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Lab: Tunes - Show the Dataview",
                                    "idx": 2,
                                    "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Lab_Tunes_Show_the_Dataview",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/First_Tab_Code_the_Thumbnails/Lab_Tunes_Show_the_Dataview.html"
                                },
                                {
                                    "name": "Style the DataView",
                                    "slug": "Style_the_DataView",
                                    "summary": "",
                                    "children": [
                                        {
                                            "name": "Sass",
                                            "slug": "Sass",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Sass",
                                            "idx": 1,
                                            "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Sass",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Sass.html"
                                        },
                                        {
                                            "name": "Ext JS Variables",
                                            "slug": "Ext_JS_Variables",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Ext JS Variables",
                                            "idx": 2,
                                            "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Ext_JS_Variables",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Ext_JS_Variables.html"
                                        },
                                        {
                                            "name": "Folders",
                                            "slug": "Folders",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Folders",
                                            "idx": 3,
                                            "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Folders",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Folders.html"
                                        },
                                        {
                                            "name": "Lab: Tunes - Style the View",
                                            "slug": "Lab_Tunes_Style_the_View",
                                            "summary": "",
                                            "navTreeName": "Guides",
                                            "text": "Lab: Tunes - Style the View",
                                            "idx": 4,
                                            "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Lab_Tunes_Style_the_View",
                                            "leaf": true,
                                            "iconCls": "fa fa-file-text-o",
                                            "href": "guides/tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView/Lab_Tunes_Style_the_View.html"
                                        }
                                    ],
                                    "navTreeName": "Guides",
                                    "text": "Style the DataView",
                                    "idx": 3,
                                    "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails/Style_the_DataView",
                                    "iconCls": "fa fa-folder-o"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "First Tab: Code the Thumbnails",
                            "idx": 4,
                            "id": "tutorials/quick_start/First_Tab_Code_the_Thumbnails",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "Second Tab: Code the Grid",
                            "slug": "Second_Tab_Code_the_Grid",
                            "summary": "",
                            "children": [
                                {
                                    "name": "Ext.grid.Grid",
                                    "slug": "Ext.grid.Grid",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Ext.grid.Grid",
                                    "idx": 1,
                                    "id": "tutorials/quick_start/Second_Tab_Code_the_Grid/Ext.grid.Grid",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Second_Tab_Code_the_Grid/Ext.grid.Grid.html"
                                },
                                {
                                    "name": "Lab: Tunes - Show the Modern Grid",
                                    "slug": "Lab_Tunes_Show_the_Modern_Grid",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Lab: Tunes - Show the Modern Grid",
                                    "idx": 2,
                                    "id": "tutorials/quick_start/Second_Tab_Code_the_Grid/Lab_Tunes_Show_the_Modern_Grid",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Second_Tab_Code_the_Grid/Lab_Tunes_Show_the_Modern_Grid.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Second Tab: Code the Grid",
                            "idx": 5,
                            "id": "tutorials/quick_start/Second_Tab_Code_the_Grid",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "Show the Preview",
                            "slug": "Show_the_Preview",
                            "summary": "",
                            "children": [
                                {
                                    "name": "Ext.Dialog",
                                    "slug": "Ext.Dialog",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Ext.Dialog",
                                    "idx": 1,
                                    "id": "tutorials/quick_start/Show_the_Preview/Ext.Dialog",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Show_the_Preview/Ext.Dialog.html"
                                },
                                {
                                    "name": "Ext.Video",
                                    "slug": "Ext.Video",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Ext.Video",
                                    "idx": 2,
                                    "id": "tutorials/quick_start/Show_the_Preview/Ext.Video",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Show_the_Preview/Ext.Video.html"
                                },
                                {
                                    "name": "Lab: Code the Modern Dialog Handler",
                                    "slug": "Lab_Tunes_Code_the_Modern_Dialog_Video",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Lab: Code the Modern Dialog Handler",
                                    "idx": 3,
                                    "id": "tutorials/quick_start/Show_the_Preview/Lab_Tunes_Code_the_Modern_Dialog_Video",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Show_the_Preview/Lab_Tunes_Code_the_Modern_Dialog_Video.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Show the Preview",
                            "idx": 6,
                            "id": "tutorials/quick_start/Show_the_Preview",
                            "iconCls": "fa fa-folder-o"
                        },
                        {
                            "name": "Summary and Next Steps",
                            "slug": "Summary_and_Next_Steps",
                            "summary": "",
                            "children": [
                                {
                                    "name": "Summary",
                                    "slug": "Summary",
                                    "summary": "",
                                    "navTreeName": "Guides",
                                    "text": "Summary",
                                    "idx": 1,
                                    "id": "tutorials/quick_start/Summary_and_Next_Steps/Summary",
                                    "leaf": true,
                                    "iconCls": "fa fa-file-text-o",
                                    "href": "guides/tutorials/quick_start/Summary_and_Next_Steps/Summary.html"
                                }
                            ],
                            "navTreeName": "Guides",
                            "text": "Summary and Next Steps",
                            "idx": 7,
                            "id": "tutorials/quick_start/Summary_and_Next_Steps",
                            "iconCls": "fa fa-folder-o"
                        }
                    ],
                    "navTreeName": "Guides",
                    "text": "Quick Start",
                    "idx": 3,
                    "id": "tutorials/quick_start",
                    "iconCls": "fa fa-folder-o"
                }
            ],
            "navTreeName": "Guides",
            "text": "Tutorials",
            "idx": 13,
            "id": "tutorials",
            "iconCls": "fa fa-folder-o"
        }
    ]
}